/*
 * Decompiled with CFR 0.152.
 */
package net.skinsrestorer.bukkit.utils;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.skinsrestorer.api.property.IProperty;
import net.skinsrestorer.api.reflection.ReflectionUtil;
import net.skinsrestorer.api.reflection.exception.ReflectionException;
import net.skinsrestorer.bukkit.utils.BukkitProperty;
import org.bukkit.entity.Player;

public class BukkitPropertyApplier {
    public static void applyProperty(Player player, IProperty property) {
        try {
            GameProfile profile = BukkitPropertyApplier.getGameProfile(player);
            profile.getProperties().removeAll((Object)"textures");
            profile.getProperties().put((Object)"textures", property.getHandle());
        }
        catch (ReflectionException e) {
            e.printStackTrace();
        }
    }

    public static GameProfile getGameProfile(Player player) throws ReflectionException {
        GameProfile profile;
        Object ep = ReflectionUtil.invokeMethod(player.getClass(), player, "getHandle");
        try {
            profile = (GameProfile)ReflectionUtil.invokeMethod(ep.getClass(), ep, "getProfile");
        }
        catch (Exception e) {
            profile = (GameProfile)ReflectionUtil.getFieldByType(ep, "GameProfile");
        }
        return profile;
    }

    public static Map<String, Collection<IProperty>> getPlayerProperties(Player player) throws ReflectionException {
        Map getGameProfileProperties = BukkitPropertyApplier.getGameProfile(player).getProperties().asMap();
        HashMap<String, Collection<IProperty>> properties = new HashMap<String, Collection<IProperty>>();
        for (Map.Entry entry : getGameProfileProperties.entrySet()) {
            ArrayList<BukkitProperty> list = new ArrayList<BukkitProperty>();
            for (Property property : (Collection)entry.getValue()) {
                list.add(new BukkitProperty(property.getName(), property.getValue(), property.getSignature()));
            }
            properties.put((String)entry.getKey(), list);
        }
        return properties;
    }
}

